$Title: (12) aggregate to 20 river basins

*----------------------------------------------------------------*
*                                                                *
*            Global Trade Analysis Project                       *
*                GTAP Water database                             *
*      (12)   aggregate to 20 river basins                       *
*                                                                *
*----------------------------------------------------------------*



* ---------------------- 126 basins to 20 basins aggregation --------------------------

 vfm_(label,a,bas,agr,reg) = sum(b,  vfm_(label,a,b,agr,reg)$map_bas(reg,bas,b,'def') );
evfa_(label,a,bas,agr,reg) = sum(b, evfa_(label,a,b,agr,reg)$map_bas(reg,bas,b,'def') );
evoa_(label,a,bas,    reg) = sum(b, evoa_(label,a,b,    reg)$map_bas(reg,bas,b,'def') );
VOLUME(TAG ,a,bas,agr,reg) = sum(b,VOLUME(TAG  ,a,b,agr,reg)$map_bas(reg,bas,b,'def') );

 vfm_(label,a,b,agr,reg) = 0;
evfa_(label,a,b,agr,reg) = 0;
evoa_(label,a,b,    reg) = 0;
VOLUME(TAG ,a,b,agr,reg) = 0;


* ---------------------- irr rfd category for land water --------------------------

parameters
VFMC    VFM header for land and water by RBAEZ and IRR type   [[VFMC:AEZ18*BAS20*LW*AGR*LTYPE*REG]]
VFAC    EVFA header for land and water by RBAEZ and IRR type  [[VFAC:AEZ18*BAS20*LW*AGR*LTYPE*REG]]
VOAC    EVOA header for land and water by RBAEZ- NO IRR type  [[VOAC:AEZ18*BAS20*LW*REG]]
WATC    Water use in m3 by RBAEZ and IRR type                 [[WATC:AEZ18*BAS20*CROP*LTYPE*REG]]
PRDC    Crop production in metric ton by RBAEZ and IRR type   [[PRDC:AEZ18*BAS20*CROP*LTYPE*REG]]
HVSC    Harvested area in hectare by RBAEZ and IRR type       [[HVSC:AEZ18*BAS20*CROP*LTYPE*REG]]
COVC    Land cover in hectare by RBAEZ- NO IRR type           [[COVC:AEZ18*BAS20*COVR*REG]]
;
VFMC(AEZ18,BAS20,'LND',CROP,'IRR',REG) = vfm_("IrrLand",aez18,bas20,crop,reg);
VFMC(AEZ18,BAS20,'LND',CROP,'RFD',REG) = vfm_("RfdLand",aez18,bas20,crop,reg);
VFMC(AEZ18,BAS20,'WAT',CROP,'IRR',REG) = vfm_("Water"  ,aez18,bas20,crop,reg);
VFMC(AEZ18,BAS20,'LND',NONCROP,'OTH',REG) = vfm_("OthLand",aez18,bas20,noncrop,reg);

VFAC(AEZ18,BAS20,'LND',CROP,'IRR',REG) = evfa_("IrrLand",aez18,bas20,crop,reg);
VFAC(AEZ18,BAS20,'LND',CROP,'RFD',REG) = evfa_("RfdLand",aez18,bas20,crop,reg);
VFAC(AEZ18,BAS20,'WAT',CROP,'IRR',REG) = evfa_("Water"  ,aez18,bas20,crop,reg);
VFAC(AEZ18,BAS20,'LND',NONCROP,'OTH',REG) = evfa_("OthLand",aez18,bas20,noncrop,reg);

VOAC(AEZ18,BAS20,'WAT',REG) = evoa_("Water" ,aez18,bas20,reg);
VOAC(AEZ18,BAS20,'LND',REG) =
    evoa_("OthLand",aez18,bas20,reg) +
    evoa_("RfdLand",aez18,bas20,reg) +
    evoa_("IrrLand",aez18,bas20,reg) ;

WATC(AEZ18,BAS20,CROP,'IRR',REG) = volume('ww',AEZ18,BAS20,CROP,reg);
PRDC(AEZ18,BAS20,CROP,'IRR',REG) = volume('QI',AEZ18,BAS20,CROP,reg);
PRDC(AEZ18,BAS20,CROP,'RFD',REG) = volume('QR',AEZ18,BAS20,CROP,reg);
HVSC(AEZ18,BAS20,CROP,'IRR',REG) = volume('HI',AEZ18,BAS20,CROP,reg);
HVSC(AEZ18,BAS20,CROP,'RFD',REG) = volume('HR',AEZ18,BAS20,CROP,reg);
COVC(AEZ18,BAS20,'FORESTRY' ,REG)= volume('COVER',AEZ18,BAS20,'FRS',reg);
COVC(AEZ18,BAS20,'LIVESTOCK',REG)= volume('COVER',AEZ18,BAS20,'CTL',reg);
COVC(AEZ18,BAS20,'CROPLAND' ,REG)= volume('COVER',AEZ18,BAS20,'OAP',reg);
* %%%%%%%%%% WARNING OAP IS USED FOR CROPLAND %%%%%%%%%%


* ---------------------- old commodity to new commodity (c to ic & rc) --------------------------

 vfm_("Land",a,bas,ic,reg) = sum(c,  vfm_("IrrLand",a,bas,c,reg)$map_crop(ic,c));
evfa_("Land",a,bas,ic,reg) = sum(c, evfa_("IrrLand",a,bas,c,reg)$map_crop(ic,c));
volume(tagi ,a,bas,ic,reg) = sum(c,volume(tagi     ,a,bas,c,reg)$map_crop(ic,c));

 vfm_("Land",a,bas,rc,reg) = sum(c,  vfm_("RfdLand",a,bas,c,reg)$map_crop(rc,c));
evfa_("Land",a,bas,rc,reg) = sum(c, evfa_("RfdLand",a,bas,c,reg)$map_crop(rc,c));
volume(tagr ,a,bas,rc,reg) = sum(c,volume(tagr     ,a,bas,c,reg)$map_crop(rc,c));

 vfm_("Wtr",a,bas,ic,reg) = sum(c,  vfm_("Water",a,bas,c,reg)$map_crop(ic,c));
evfa_("Wtr",a,bas,ic,reg) = sum(c, evfa_("Water",a,bas,c,reg)$map_crop(ic,c));
evoa_("Wtr",a,bas,   reg) =        evoa_("Water",a,bas,  reg) ;

 vfm_("Land",a,bas,NONCROP,reg) =  vfm_("OthLand",a,bas,NONCROP,reg);
evfa_("Land",a,bas,NONCROP,reg) = evfa_("OthLand",a,bas,NONCROP,reg);

evoa_("Land",a,bas,reg) =
     evoa_("OthLand",a,bas,reg) +
     evoa_("RfdLand",a,bas,reg) +
     evoa_("IrrLand",a,bas,reg) ;

 vfm_(label,a,bas,agr,reg) = 0;
evfa_(label,a,bas,agr,reg) = 0;
evoa_(label,a,bas,    reg) = 0;

volume(tag ,a,bas,  c,reg) = 0;

* ---------------------- value added indexed by aez , rb --------------------------

parameters
  VFMZ    VFM header for land and water by RBAEZ   [[VFMZ:AEZ18*BAS20*LW*AGR_COMM*REG]]
  VFAZ    EVFA header for land and water by RBAEZ  [[VFAZ:AEZ18*BAS20*LW*AGR_COMM*REG]]
  VOAZ    EVOA header for land and water by RBAEZ  [[VOAZ:AEZ18*BAS20*LW*REG]]
  WATZ    Water use in m3 by RBAEZ                 [[WATZ:AEZ18*BAS20*WATER_INDS*REG]]
  PRDZ    Crop production in metric ton by RBAEZ   [[PRDZ:AEZ18*BAS20*CROP_COMM*REG]]
  HVSZ    Harvested area in hectare by RBAEZ       [[HVSZ:AEZ18*BAS20*CROP_COMM*REG]]
  COVZ    Land cover in hectare by RBAEZ           [[COVZ:AEZ18*BAS20*COVR*REG]]
;
VFMZ(AEZ18,BAS20,'LND',AGR_COMM,REG) = vfm_("Land",aez18,bas20,agr_comm,reg);
VFMZ(AEZ18,BAS20,'WAT',AGR_COMM,REG) = vfm_("Wtr" ,aez18,bas20,agr_comm,reg);

VFAZ(AEZ18,BAS20,'LND',AGR_COMM,REG) =evfa_("Land",aez18,bas20,agr_comm,reg);
VFAZ(AEZ18,BAS20,'WAT',AGR_COMM,REG) =evfa_("Wtr" ,aez18,bas20,agr_comm,reg);

VOAZ(AEZ18,BAS20,'LND',REG) = evoa_("Land",aez18,bas20,reg);
VOAZ(AEZ18,BAS20,'WAT',REG) = evoa_("Wtr" ,aez18,bas20,reg);


WATZ(AEZ18,BAS20,WATER_INDS,REG) = volume('ww',AEZ18,BAS20,WATER_INDS,reg);
PRDZ(AEZ18,BAS20,IC,REG)         = volume('QI',AEZ18,BAS20,IC,reg);
PRDZ(AEZ18,BAS20,RC,REG)         = volume('QR',AEZ18,BAS20,RC,reg);
HVSZ(AEZ18,BAS20,IC,REG)         = volume('HI',AEZ18,BAS20,IC,reg);
HVSZ(AEZ18,BAS20,RC,REG)         = volume('HR',AEZ18,BAS20,RC,reg);
COVZ(AEZ18,BAS20,'FORESTRY' ,REG)= volume('COVER',AEZ18,BAS20,'FRS',reg);
COVZ(AEZ18,BAS20,'LIVESTOCK',REG)= volume('COVER',AEZ18,BAS20,'CTL',reg);
COVZ(AEZ18,BAS20,'CROPLAND' ,REG)= volume('COVER',AEZ18,BAS20,'OAP',reg);
* %%%%%%%%%% WARNING OAP IS USED FOR CROPLAND %%%%%%%%%%


parameters
  VFMW     VFM header for land and water at regional level [[VFMW:LW*AGR_COMM*REG]]
  VFAW    EVFA header for land and water at regional level [[VFAW:LW*AGR_COMM*REG]]
  VOAW    EVOA header for land and water at regional level [[VOAW:LW*REG]]
  WATW    Water use in m3 at regional level                [[WATW:WATER_INDS*REG]]
  PRDW    Crop production in metric ton at regional level  [[PRDW:CROP_COMM*REG]]
  HVSW    Harvested area in hectare at regional level      [[HVSW:CROP_COMM*REG]]
  COVW    Land cover in hectare at regional level          [[COVW:COVR*REG]]
;
VFMW('LND',AGR_COMM,REG) = sum((aez18,bas20), vfm_("Land",aez18,bas20,agr_comm,reg));
VFMW('WAT',AGR_COMM,REG) = sum((aez18,bas20), vfm_("Wtr" ,aez18,bas20,agr_comm,reg));

VFAW('LND',AGR_COMM,REG) =sum((aez18,bas20), evfa_("Land",aez18,bas20,agr_comm,reg));
VFAW('WAT',AGR_COMM,REG) =sum((aez18,bas20), evfa_("Wtr" ,aez18,bas20,agr_comm,reg));

VOAW('LND',REG) = sum((aez18,bas20), evoa_("Land",aez18,bas20,reg));
VOAW('WAT',REG) = sum((aez18,bas20), evoa_("Wtr" ,aez18,bas20,reg));


WATW(WATER_INDS,REG) = SUM((AEZ18,BAS20),volume('ww',AEZ18,BAS20,WATER_INDS,reg));
PRDW(IC,REG)         = SUM((AEZ18,BAS20),volume('QI',AEZ18,BAS20,IC,reg));
PRDW(RC,REG)         = SUM((AEZ18,BAS20),volume('QR',AEZ18,BAS20,RC,reg));
HVSW(IC,REG)         = SUM((AEZ18,BAS20),volume('HI',AEZ18,BAS20,IC,reg));
HVSW(RC,REG)         = SUM((AEZ18,BAS20),volume('HR',AEZ18,BAS20,RC,reg));
COVW('FORESTRY' ,REG)= SUM((AEZ18,BAS20),volume('COVER',AEZ18,BAS20,'FRS',reg));
COVW('LIVESTOCK',REG)= SUM((AEZ18,BAS20),volume('COVER',AEZ18,BAS20,'CTL',reg));
COVW('CROPLAND' ,REG)= SUM((AEZ18,BAS20),volume('COVER',AEZ18,BAS20,'OAP',reg));
* %%%%%%%%%% WARNING OAP IS USED FOR CROPLAND %%%%%%%%%%


parameters
  VFMA    VFM header for land and water by AEZ   [[VFMA:AEZ18*LW*AGR_COMM*REG]]
  VFAA    EVFA header for land and water by AEZ  [[VFAA:AEZ18*LW*AGR_COMM*REG]]
  VOAA    EVOA header for land and water by AEZ  [[VOAA:AEZ18*LW*REG]]
  WATA    Water use in m3 by AEZ                 [[WATA:AEZ18*WATER_INDS*REG]]
  PRDA    Crop production in metric ton by AEZ   [[PRDA:AEZ18*CROP_COMM*REG]]
  HVSA    Harvested area in hectare by AEZ       [[HVSA:AEZ18*CROP_COMM*REG]]
  COVA    Land cover in hectare by AEZ           [[COVA:AEZ18*COVR*REG]]
;
VFMA(AEZ18,'LND',AGR_COMM,REG) = sum(bas20, vfm_("Land",aez18,bas20,agr_comm,reg));
VFMA(AEZ18,'WAT',AGR_COMM,REG) = sum(bas20, vfm_("Wtr" ,aez18,bas20,agr_comm,reg));

VFAA(AEZ18,'LND',AGR_COMM,REG) =sum(bas20, evfa_("Land",aez18,bas20,agr_comm,reg));
VFAA(AEZ18,'WAT',AGR_COMM,REG) =sum(bas20, evfa_("Wtr" ,aez18,bas20,agr_comm,reg));

VOAA(AEZ18,'LND',REG) = sum(bas20, evoa_("Land",aez18,bas20,reg));
VOAA(AEZ18,'WAT',REG) = sum(bas20, evoa_("Wtr" ,aez18,bas20,reg));


WATA(AEZ18,WATER_INDS,REG) = SUM((BAS20),volume('ww',AEZ18,BAS20,WATER_INDS,reg));
PRDA(AEZ18,IC,REG)         = SUM((BAS20),volume('QI',AEZ18,BAS20,IC,reg));
PRDA(AEZ18,RC,REG)         = SUM((BAS20),volume('QR',AEZ18,BAS20,RC,reg));
HVSA(AEZ18,IC,REG)         = SUM((BAS20),volume('HI',AEZ18,BAS20,IC,reg));
HVSA(AEZ18,RC,REG)         = SUM((BAS20),volume('HR',AEZ18,BAS20,RC,reg));
COVA(AEZ18,'FORESTRY' ,REG)= SUM((BAS20),volume('COVER',AEZ18,BAS20,'FRS',reg));
COVA(AEZ18,'LIVESTOCK',REG)= SUM((BAS20),volume('COVER',AEZ18,BAS20,'CTL',reg));
COVA(AEZ18,'CROPLAND' ,REG)= SUM((BAS20),volume('COVER',AEZ18,BAS20,'OAP',reg));
* %%%%%%%%%% WARNING OAP IS USED FOR CROPLAND %%%%%%%%%%


parameters
  VFMB    VFM header for land and water by RB   [[VFMB:BAS20*LW*AGR_COMM*REG]]
  VFAB    EVFA header for land and water by RB  [[VFAB:BAS20*LW*AGR_COMM*REG]]
  VOAB    EVOA header for land and water by RB  [[VOAB:BAS20*LW*REG]]
  WATB    Water use in m3 by RB                 [[WATB:BAS20*WATER_INDS*REG]]
  PRDB    Crop production in metric ton by RB   [[PRDB:BAS20*CROP_COMM*REG]]
  HVSB    Harvested area in hectare by RB       [[HVSB:BAS20*CROP_COMM*REG]]
  COVB    Land cover in hectare by RB           [[COVB:BAS20*COVR*REG]]
;
VFMB(BAS20,'LND',AGR_COMM,REG) = sum(aez18, vfm_("Land",aez18,bas20,agr_comm,reg));
VFMB(BAS20,'WAT',AGR_COMM,REG) = sum(aez18, vfm_("Wtr" ,aez18,bas20,agr_comm,reg));

VFAB(BAS20,'LND',AGR_COMM,REG) =sum(aez18, evfa_("Land",aez18,bas20,agr_comm,reg));
VFAB(BAS20,'WAT',AGR_COMM,REG) =sum(aez18, evfa_("Wtr" ,aez18,bas20,agr_comm,reg));

VOAB(BAS20,'LND',REG) = sum(aez18, evoa_("Land",aez18,bas20,reg));
VOAB(BAS20,'WAT',REG) = sum(aez18, evoa_("Wtr" ,aez18,bas20,reg));

WATB(BAS20,WATER_INDS,REG) = SUM((AEZ18),volume('ww',AEZ18,BAS20,WATER_INDS,reg));
PRDB(BAS20,IC,REG)         = SUM((AEZ18),volume('QI',AEZ18,BAS20,IC,reg));
PRDB(BAS20,RC,REG)         = SUM((AEZ18),volume('QR',AEZ18,BAS20,RC,reg));
HVSB(BAS20,IC,REG)         = SUM((AEZ18),volume('HI',AEZ18,BAS20,IC,reg));
HVSB(BAS20,RC,REG)         = SUM((AEZ18),volume('HR',AEZ18,BAS20,RC,reg));
COVB(BAS20,'FORESTRY' ,REG)= SUM((AEZ18),volume('COVER',AEZ18,BAS20,'FRS',reg));
COVB(BAS20,'LIVESTOCK',REG)= SUM((AEZ18),volume('COVER',AEZ18,BAS20,'CTL',reg));
COVB(BAS20,'CROPLAND' ,REG)= SUM((AEZ18),volume('COVER',AEZ18,BAS20,'OAP',reg));
* %%%%%%%%%% WARNING OAP IS USED FOR CROPLAND %%%%%%%%%%




* ---------------------- new endw_comm mapping --------------------------
 vfm(aez360,prod_comm,reg) =
     sum((aez,bas), vfm_("land",aez,bas,prod_comm,reg)$map_lnd(aez360,bas,aez,'def')) + eps;

evfa(aez360,prod_comm,reg) =
     sum((aez,bas), evfa_("land",aez,bas,prod_comm,reg)$map_lnd(aez360,bas,aez,'def')) + eps;

evoa(aez360,          reg) =
     sum((aez,bas), evoa_("land",aez,bas,          reg)$map_lnd(aez360,bas,aez,'def')) + eps;

volume(tag,'NEW',aez360,prod_comm,reg) =
     sum((aez,bas), volume(tag,aez,bas,prod_comm,reg)$map_lnd(aez360,bas,aez,'def')) + eps;



 vfm(bas360,prod_comm,reg) =
     sum((aez,bas), vfm_("wtr",aez,bas,prod_comm,reg)$map_wat(bas360,bas,aez,'def')) + eps;

evfa(bas360,prod_comm,reg) =
     sum((aez,bas), evfa_("wtr",aez,bas,prod_comm,reg)$map_wat(bas360,bas,aez,'def')) + eps;

evoa(bas360,          reg) =
     sum((aez,bas), evoa_("wtr",aez,bas,          reg)$map_wat(bas360,bas,aez,'def')) + eps;

volume('ww','NEW',bas360,prod_comm,reg) =
     sum((aez,bas), volume('ww',aez,bas,prod_comm,reg)$map_wat(bas360,bas,aez,'def')) + eps;

 vfm('land',prod_comm,reg) = 0;
evfa('land',prod_comm,reg) = 0;
evoa('land',          reg) = 0;

volume('ww','NEW',aez360,prod_comm,reg) =  0;
volume(TAG,AEZ,BAS,prod_comm,reg) =  0;

 vfm('capital','cgds',reg) = eps;
evfa('capital','cgds',reg) = eps;




PARAMETERS
WATER(BAS360,WATER_INDS,REG)      Water used by basin-aez in m3 [[WATE]]
PRODUCTION(AEZ360,CROP_COMM,REG)  Crop production by basin-aez in metric ton [[PRDN]]
AREA(AEZ360,CROP_COMM,REG)        Harvested area by basin-aez in hectare [[AREA]]
LANDCOVER(AEZ360,COVR,REG)        Land cover by basin-aez in hectare [[COVR]]
;

WATER(BAS360,WATER_INDS,REG)      = volume('ww','NEW',BAS360,WATER_INDS,reg);
PRODUCTION(AEZ360,IC,REG)         = volume('QI','NEW',AEZ360,IC,reg);
PRODUCTION(AEZ360,RC,REG)         = volume('QR','NEW',AEZ360,RC,reg);
AREA(AEZ360,IC,REG)               = volume('HI','NEW',AEZ360,IC,reg);
AREA(AEZ360,RC,REG)               = volume('HR','NEW',AEZ360,RC,reg);
LANDCOVER(AEZ360,'FORESTRY',REG)  = volume('COVER','NEW',AEZ360,'FRS',reg);
LANDCOVER(AEZ360,'LIVESTOCK',REG) = volume('COVER','NEW',AEZ360,'CTL',reg);

* %%%%%%%%%% WARNING OAP IS USED FOR CROPLAND %%%%%%%%%%
LANDCOVER(AEZ360,'CROPLAND' ,REG) = volume('COVER','NEW',AEZ360,'OAP',reg);
